% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_color_okabeito.R
\name{palette_okabeito}
\alias{palette_okabeito}
\alias{palette_oi}
\title{Okabe-Ito color palette}
\usage{
palette_okabeito(palette = "full", reverse = FALSE, order = 1:9, ...)

palette_oi(palette = "full", reverse = FALSE, order = 1:9, ...)
}
\arguments{
\item{palette}{Character name of palette. Depending on the color scale, can
be \code{"full"}, \code{"ice"}, \code{"rainbow"}, \code{"complement"},
\code{"contrast"}, \code{"light"} (for dark themes), or \code{"black_first"}.}

\item{reverse}{Boolean indicating whether the palette should be reversed.}

\item{order}{A vector of numbers from 1 to 9 indicating the order of colors to use
(default: \code{1:9})}

\item{...}{Additional arguments to pass to \code{\link[=colorRampPalette]{colorRampPalette()}}.}
}
\description{
The palette based proposed by Okabe and Ito (2008).
}
\details{
This function is usually not called directly, but from within
\code{\link[=scale_color_material]{scale_color_material()}}.
}
\references{
Okabe, M., & Ito, K. (2008). Color universal design (CUD):
How to make figures and presentations that are friendly to colorblind people.
https://jfly.uni-koeln.de/color/#pallet (Original work published 2002)
}
