\name{fitMod}
\alias{fitMod}
\title{Internal function that fits the seawaveQ model.}
\usage{
  fitMod(cdatsub, cavdat, yrstart, yrend, tndbeg, tndend,
    tanm, pnames, qwcols, mclass = 1)
}
\arguments{
  \item{cdatsub}{is the concentration data}

  \item{cavdat}{is the continuous (daily) ancillary data}

  \item{yrstart}{is the starting year of the analysis
  (treated as January 1 of that year).}

  \item{yrend}{is the ending year of the analysis (treated
  as December 31 of that year).}

  \item{tndbeg}{is the beginning (in whole or decimal
  years) of the trend period.}

  \item{tndend}{is the end (in whole or decimal years) of
  the trend period.}

  \item{tanm}{is a character identifier that names the
  trend analysis run.  It is used to label output files.}

  \item{pnames}{is the parameter (water-quality
  constituents) to analyze (if using USGS parameters, omit
  the the starting 'P', such as "00945" for sulfate).}

  \item{qwcols}{is a character vector with the beginning of
  the column headers for remarks code (default is R), and
  beginning of column headers for concentration data
  (default is P for parameter).}

  \item{mclass}{has not been implemented yet, but will
  provide additional model options.}
}
\value{
  a pdf file containing plots (see
  \code{\link{seawaveQPlots}}), a text file showing the
  best model survival regression call and results, and a
  list.  The first element of the list contains information
  about the data and the model(s) selected (see
  \code{\link{examplestpars}}). The second element of the
  list contains the summary of the survival regression
  call.  The third element of the list is itself a list
  containing the observed concentrations (censored and
  uncensored) and the predicted concentrations used by
  \code{\link{seawaveQPlots}} to generate the plots.
}
\description{
  fitMod is called from within \link{fitswavecav} but can
  be invoked directly.  It fits the seawaveQ model and
  returns the results.
}
\examples{
data(swData)
myRes <- fitMod(cdatsub=examplecdatsub, cavdat=examplecavdat,
yrstart=1995, yrend=2003, tndbeg=1995, tndend=2003, tanm="myfit3",
pnames=c("04041"), qwcols=c("R", "P"))
}
\author{
  Aldo V. Vecchia and Karen R. Ryberg
}
\keyword{models}
\keyword{regression}
\keyword{survival}
\keyword{ts}

