% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq_xts.R
\name{freq_xts}
\alias{freq_xts}
\title{Obtain the frequency of an xts time series}
\usage{
freq_xts(series)
}
\arguments{
\item{series}{time series}
}
\description{
Estimate the number of periods per year of an xts time series
}
\details{
The function gives back the average number of observations per year calculated on the whole series except for the first and the last year.
}
\examples{
x <- xts::xts(rnorm(100), seq.Date(from=as.Date("2010-01-01"), by="months", length.out=100))
frequency(x)
}
\author{
Daniel Ollech
}
