% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/woebin.R
\name{woebin_plot}
\alias{woebin_plot}
\title{WOE Binning Visualization}
\usage{
woebin_plot(bins, x = NULL, title = NULL, show_iv = TRUE, ...)
}
\arguments{
\item{bins}{A list of data frames. Binning information generated by \code{woebin}.}

\item{x}{Name of x variables. Default is NULL. If x is NULL, then all columns except y are counted as x variables.}

\item{title}{String added to the plot title. Default is NULL.}

\item{show_iv}{Logical. Default is TRUE, which means show information value in the plot title.}

\item{...}{Additional parameters}
}
\value{
A list of binning graphics.
}
\description{
\code{woebin_plot} create plots of count distribution and bad probability for each bin. The binning informations are generates by  \code{woebin}.
}
\examples{
# Load German credit data
data(germancredit)

# Example I
bins1 = woebin(germancredit, y="creditability", x="credit.amount")

p1 = woebin_plot(bins1)
print(p1)
# modify colors
p1_c = woebin_plot(bins1, line_color='#FC8D59', bar_color=c('#FFFFBF', '#99D594'))
print(p1_c)

\donttest{
# Example II
bins = woebin(germancredit, y="creditability")
plotlist = woebin_plot(bins)
print(plotlist$credit.amount)

# # save binning plot
# for (i in 1:length(plotlist)) {
#   ggplot2::ggsave(
#      paste0(names(plotlist[i]), ".png"), plotlist[[i]],
#      width = 15, height = 9, units="cm" )
#   }
}

}
\seealso{
\code{\link{woebin}}, \code{\link{woebin_ply}}, \code{\link{woebin_adj}}
}
