% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residPlot.R
\name{residPlot}
\alias{residPlot}
\title{Fitted values versus residuals plot}
\usage{
residPlot(lmfit, f = 0.5)
}
\arguments{
\item{lmfit}{an \code{lm} object, i.e. the output from \code{lm}.}

\item{f}{the smoother span. This gives the proportion of points in the plot
which influence the smooth at each value. Larger values give more
smoothness.}
}
\value{
Returns the plot.
}
\description{
Plots a scatter plot for the variables of the residuals and fitted values
from the linear model, lmfit. A lowess smooth line for the underlying trend,
as well as one standard deviation error bounds for the scatter about this
trend, are added to this scatter plot. A test for a quadratic relationship
between the residuals and the fitted values is also computed.
}
\note{
This function is deprecated. It will be removed in future versions of the package.
}
\examples{

# Peruvian Indians data
data(peru.df)
fit=lm(BP~age+years+weight+height, data = peru.df)
residPlot(fit)

}
\seealso{
\code{\link{trendscatter}}
}
\keyword{hplot}
