% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsvg.R
\name{dsvg}
\alias{dsvg}
\title{SVG Graphics Driver}
\usage{
dsvg(file = "Rplots.svg", width = 6, height = 6, bg = "white",
  pointsize = 12, standalone = TRUE, canvas_id = 1,
  fontname_serif = "Times New Roman", fontname_sans = "Calibri",
  fontname_mono = "Courier New", fontname_symbol = "Symbol")
}
\arguments{
\item{file}{the file where output will appear.}

\item{height, width}{Height and width in inches.}

\item{bg}{Default background color for the plot (defaults to "white").}

\item{pointsize}{default point size.}

\item{standalone}{Produce a stand alone svg file? If \code{FALSE}, omits
xml header and default namespace.}

\item{canvas_id}{svg id within HTML page.}

\item{fontname_serif, fontname_sans, fontname_mono, fontname_symbol}{font
names for font faces.
Used fonts should be available in the operating system.}
}
\description{
This function produces SVG files (compliant to the current w3 svg XML standard)
where elements can be made interactive.
}
\details{
Graphic elements are made interactive with \code{jQuery} code. To embed
an interactive svg file into a web page, check that \code{jQuery} javascript file
is included.
}
\examples{
dsvg()
plot(rnorm(10), main="Simple Example", xlab = "", ylab = "")
dev.off()
}
\seealso{
\code{\link{Devices}}, \code{\link{dml_docx}}, \code{\link{dml_pptx}}
}
\keyword{device}

