% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoencoder_variational.R
\name{to_keras.ruta_layer_variational}
\alias{to_keras.ruta_layer_variational}
\title{Obtain a Keras block of layers for the variational autoencoder}
\usage{
\method{to_keras}{ruta_layer_variational}(x, input_shape, model = keras::keras_model_sequential(), ...)
}
\arguments{
\item{x}{The layer object}

\item{input_shape}{Number of features in training data}

\item{model}{Keras model where the layers will be added}

\item{...}{Unused}
}
\value{
A Layer object from Keras
}
\description{
This block contains two dense layers representing the mean and log var of a Gaussian
distribution and a sampling layer.
}
\references{
\itemize{
\item \href{https://arxiv.org/abs/1312.6114}{Auto-Encoding Variational Bayes}
\item \href{https://blog.fastforwardlabs.com/2016/08/22/under-the-hood-of-the-variational-autoencoder-in.html}{Under the Hood of the Variational Autoencoder (in Prose and Code)}
\item \href{https://github.com/rstudio/keras/blob/main/vignettes/examples/variational_autoencoder.R}{Keras example: Variational autoencoder}
}
}
