% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoencoder_denoising.R
\name{autoencoder_denoising}
\alias{autoencoder_denoising}
\title{Create a denoising autoencoder}
\usage{
autoencoder_denoising(network, loss = "mean_squared_error",
  noise_type = "zeros", ...)
}
\arguments{
\item{network}{Layer construct of class \code{"ruta_network"}}

\item{loss}{Loss function to be optimized}

\item{noise_type}{Type of data corruption which will be used to train the
autoencoder, as a character string. Available types:
\itemize{
\item \code{"zeros"} Randomly set components to zero (\code{\link{noise_zeros}})
\item \code{"ones"} Randomly set components to one (\code{\link{noise_ones}})
\item \code{"saltpepper"} Randomly set components to zero or one (\code{\link{noise_saltpepper}})
\item \code{"gaussian"} Randomly offset each component of an input as drawn from
Gaussian distributions with the same variance (additive Gaussian noise,
\code{\link{noise_gaussian}})
\item \code{"cauchy"} Randomly offset each component of an input as drawn from
Cauchy distributions with the same scale (additive Cauchy noise,
\code{\link{noise_cauchy}})
}}

\item{...}{Extra parameters to customize the noisy filter:
\itemize{
\item \code{p} The probability that each instance in the input data which will be
altered by random noise (for \code{"zeros"}, \code{"ones"} and \code{"saltpepper"})
\item \code{var} or \code{sd} The variance or standard deviation of the Gaussian
distribution from which additive noise will be drawn (for \code{"gaussian"},
only one of those parameters is necessary)
\item \code{scale} For the Cauchy distribution
}}
}
\value{
A construct of class \code{"ruta_autoencoder"}
}
\description{
A denoising autoencoder trains with noisy data in order to
create a model able to reduce noise in reconstructions from input data
}
\references{
\itemize{
\item \href{https://dl.acm.org/citation.cfm?id=1390294}{Extracting and composing robust features with denoising autoencoders}
}
}
\seealso{
Other autoencoder variants: \code{\link{autoencoder_contractive}},
  \code{\link{autoencoder_robust}},
  \code{\link{autoencoder_sparse}},
  \code{\link{autoencoder_variational}},
  \code{\link{autoencoder}}
}
