% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rt_ticket_history.R
\name{rt_ticket_history}
\alias{rt_ticket_history}
\title{Get a ticket's history}
\usage{
rt_ticket_history(ticket_id, format = "l", ...)
}
\arguments{
\item{ticket_id}{(numeric) The ticket identifier}

\item{format}{(character) The format of the ticket history response. Either
\code{s} (ticket ID and subject) or \code{l} (full ticket metadata).
Defaults to \code{l}.}

\item{...}{Other arguments passed to \code{\link{rt_GET}}}
}
\value{
(rt_api) An \code{rt_api} object with the response
}
\description{
Get a ticket's history
}
\examples{
\dontrun{
# Get the full ticket history for ticket 992
rt_ticket_history(992)

# Get just the ticket ID and subject for ticket 992
rt_ticket_history(992, format = "s")
}
}
