/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.xpdl;

import java.util.HashMap;
import java.util.Map;
import org.vikamine.kernel.subgroup.search.BSD;
import org.vikamine.kernel.subgroup.search.NumericBSD;
import org.vikamine.kernel.subgroup.search.SDBeamSearch;
import org.vikamine.kernel.subgroup.search.SDMap;

public class MMethod {
    private final Class method;
    private static final Map<String, Class> additionalSDMethods = new HashMap<String, Class>();

    public static final void addSDAlgorithm(String s, Class c) {
        additionalSDMethods.put(s, c);
    }

    public MMethod(String name) {
        name = name.toLowerCase();
        if (name.equals("sd-map") || name.equals("sdmap")) {
            this.method = SDMap.class;
        } else if (name.equals("beam_search") || name.equals("sdbeamsearch")) {
            this.method = SDBeamSearch.class;
        } else if (name.equals("bsd") || name.equals("bitsetsd")) {
            this.method = BSD.class;
        } else if (name.equals("numericbsd")) {
            this.method = NumericBSD.class;
        } else if (additionalSDMethods.containsKey(name)) {
            this.method = additionalSDMethods.get(name);
        } else {
            throw new IllegalArgumentException("Not a valid common subgroup disovery method: " + name);
        }
    }

    public Class getName() {
        return this.method;
    }
}

