% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_year.R
\name{sc_year}
\alias{sc_year}
\title{Select scorecard data year.}
\usage{
sc_year(sccall, year)
}
\arguments{
\item{sccall}{Current list of parameters carried forward from prior
functions in the chain (ignore)}

\item{year}{Four-digit year or string \code{latest} for latest data.}
}
\description{
This function is used to select the year of the data.
}
\section{Important notes}{

\enumerate{
\item Not all variables have a year option.
\item At this time, only one year at a time is allowed.
\item The year selected is not necessarily the year the data were produced.
It may be the year the data were collected. For data collected over split
years (fall to spring), it is likely the year represents the fall data (\emph{e.g.,}
2011 for 2011/2012 data).
}

Be sure to check with the College Scorecard
\href{https://collegescorecard.ed.gov/data/documentation/}{data
documentation report} when choosing the year.
}

\examples{
\dontrun{
sc_year() # latest
sc_year('latest')
sc_year(2012)
}
}
