% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trees.R
\name{fix.semicolon.tree}
\alias{fix.semicolon.tree}
\title{Add a semi-colon to end of tree string}
\usage{
fix.semicolon.tree(x)
}
\arguments{
\item{x}{A character string or vector of character strings each
representing a tree in Newick format.}
}
\value{
The same value, but with a semi-colon added to the end
of any strings which did not already end in semi-colons.
}
\description{
Check if tree string ends in semi-colon and if not add one.  This
is mostly done for compatibility with ape, which requires them.
}
\examples{
str <- c("213", "345")
fix.semicolon.tree(str)
str <- c("213;", "345;")
fix.semicolon.tree(str)
str <- c("213", "345;")
fix.semicolon.tree(str)
}
\author{
Melissa J. Hubisz
}

