% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Expression.R
\name{BinOp}
\alias{BinOp}
\title{BinOp}
\description{
Create a binary operation expression
}
\examples{
newBinOp = BinOp$new(lhs = Int$new(2), binop = "+", rhs = Int$new(5))
newBinOp$c_str()
newBinOp$setLhs(Int$new(5))
newBinOp$setOp("-")
newBinOp$setRhs(Int$new(2))
newBinOp$c_str()
}
\section{Super class}{
\code{\link[rminizinc:Expression]{rminizinc::Expression}} -> \code{BinOp}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.lhs_exp}}{the left hand side expression}

\item{\code{.rhs_exp}}{the right hand side expression}

\item{\code{.op}}{the operator}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{.lhs_exp}}{the left hand side expression}

\item{\code{.rhs_exp}}{the right hand side expression}

\item{\code{.op}}{the operator}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{BinOp$new()}}
\item \href{#method-getLhs}{\code{BinOp$getLhs()}}
\item \href{#method-getRhs}{\code{BinOp$getRhs()}}
\item \href{#method-getOp}{\code{BinOp$getOp()}}
\item \href{#method-setOp}{\code{BinOp$setOp()}}
\item \href{#method-setLhs}{\code{BinOp$setLhs()}}
\item \href{#method-setRhs}{\code{BinOp$setRhs()}}
\item \href{#method-c_str}{\code{BinOp$c_str()}}
\item \href{#method-getDeleteFlag}{\code{BinOp$getDeleteFlag()}}
\item \href{#method-delete}{\code{BinOp$delete()}}
\item \href{#method-clone}{\code{BinOp$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BinOp$new(lhs, binop, rhs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lhs}}{the left hand side expression}

\item{\code{binop}}{the binary operator to be used}

\item{\code{rhs}}{the right hand side expression}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getLhs"></a>}}
\if{latex}{\out{\hypertarget{method-getLhs}{}}}
\subsection{Method \code{getLhs()}}{
get the lhs expression
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BinOp$getLhs()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getRhs"></a>}}
\if{latex}{\out{\hypertarget{method-getRhs}{}}}
\subsection{Method \code{getRhs()}}{
get the rhs expression
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BinOp$getRhs()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getOp"></a>}}
\if{latex}{\out{\hypertarget{method-getOp}{}}}
\subsection{Method \code{getOp()}}{
get the operator
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BinOp$getOp()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setOp"></a>}}
\if{latex}{\out{\hypertarget{method-setOp}{}}}
\subsection{Method \code{setOp()}}{
set the operator
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BinOp$setOp(binop)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{op}}{binary operator to be set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setLhs"></a>}}
\if{latex}{\out{\hypertarget{method-setLhs}{}}}
\subsection{Method \code{setLhs()}}{
set the lhs expression
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BinOp$setLhs(e)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{e}}{expression to set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setRhs"></a>}}
\if{latex}{\out{\hypertarget{method-setRhs}{}}}
\subsection{Method \code{setRhs()}}{
set the rhs expression
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BinOp$setRhs(e)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{e}}{expression to set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-c_str"></a>}}
\if{latex}{\out{\hypertarget{method-c_str}{}}}
\subsection{Method \code{c_str()}}{
return the MiniZinc representation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BinOp$c_str()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDeleteFlag"></a>}}
\if{latex}{\out{\hypertarget{method-getDeleteFlag}{}}}
\subsection{Method \code{getDeleteFlag()}}{
delete flag for internal use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BinOp$getDeleteFlag()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete"></a>}}
\if{latex}{\out{\hypertarget{method-delete}{}}}
\subsection{Method \code{delete()}}{
delete the assignment item
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BinOp$delete()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BinOp$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
