# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title MiniZinc model evaluation
#' 
#' @description evaluates the MiniZinc model
#'
#' @importFrom Rcpp sourceCpp
#' @export mzn_eval
#' @useDynLib rminizinc, .registration=TRUE
#' @param lib_path the path of the library where the solver is present.
#' @param r_model R6 Model object
#' @param mzn_path path of the mzn file to be solved
#' @param model_string model string to be solved.
#' @param solver the name of the solver to use.
#' @param dzn_path path of the datafile to be used.
#' @param all_solutions bool to specify if all solutions are specified.
#' @param time_limit stop after <time_limit> milliseconds
mzn_eval <- function(lib_path = "", r_model = NULL, mzn_path = "", model_string = "", solver = "org.gecode.gecode", dzn_path = "", all_solutions = TRUE, time_limit = 300000L) {
    .Call(`_rminizinc_mzn_eval`, lib_path, r_model, mzn_path, model_string, solver, dzn_path, all_solutions, time_limit)
}

#' @title MiniZinc syntax parser
#' 
#' @description parses the MiniZinc syntax into R objects
#'
#' @importFrom Rcpp sourceCpp
#' @export mzn_parse
#' @useDynLib rminizinc, .registration=TRUE
#' @param model_string string representation of the MiniZinc model.
#' @param mzn_path the path of model mzn.
#' @param include_path path of the included mzn in the model if it exists.
mzn_parse <- function(model_string = "", mzn_path = "", include_path = NULL) {
    .Call(`_rminizinc_mzn_parse`, model_string, mzn_path, include_path)
}

#' @title parse the solution
#' 
#' @description can parse the JSON solution of a model to 
#' return a list output
#' @importFrom Rcpp sourceCpp
#' @import rjson
#' @export sol_parse
#' @useDynLib rminizinc, .registration=TRUE
#' @param solutionString solution of the model as a string representation
sol_parse <- function(solutionString) {
    .Call(`_rminizinc_sol_parse`, solutionString)
}

