% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{subsetLiger}
\alias{subsetLiger}
\title{Construct a liger object with a specified subset}
\usage{
subsetLiger(
  object,
  clusters.use = NULL,
  cells.use = NULL,
  remove.missing = TRUE
)
}
\arguments{
\item{object}{\code{liger} object. Should run quantileAlignSNF and runTSNE before calling.}

\item{clusters.use}{Clusters to use for subset.}

\item{cells.use}{Vector of cell names to keep from any dataset.}

\item{remove.missing}{Whether to remove genes/cells with no expression when creating new object
(default TRUE).}
}
\value{
\code{liger} object with subsetting applied to raw.data, norm.data, scale.data, H, W, V,
  H.norm, tsne.coords, and clusters.
}
\description{
The subset can be based on cell names or clusters. This function applies the subsetting to
raw.data, norm.data, scale.data, cell.data, H, W, V, H.norm, tsne.coords, and clusters.
Note that it does NOT reoptimize the factorization. See optimizeSubset for this functionality.
}
\examples{
ligerex <- createLiger(list(ctrl = ctrl, stim = stim))
lig.small <- subsetLiger(ligerex, cells.use = c(colnames(ctrl)[1:100], colnames(stim)[1:100]))
}
