% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R
\name{j_schema_is_valid}
\alias{j_schema_is_valid}
\alias{j_schema_validate}
\title{Validate JSON documents against JSON Schema}
\usage{
j_schema_is_valid(
  data,
  schema,
  ...,
  data_type = j_data_type(data),
  schema_type = j_data_type(schema)
)

j_schema_validate(
  data,
  schema,
  as = "string",
  ...,
  data_type = j_data_type(data),
  schema_type = j_data_type(schema)
)
}
\arguments{
\item{data}{JSON character vector, file, or URL defining document
to be validated. NDJSON data and schema are not supported.}

\item{schema}{JSON character vector, file, or URL defining the
schema against which \code{data} will be validated.}

\item{...}{passed to \code{jsonlite::toJSON} when \code{data} is not
character-valued.}

\item{data_type}{character(1) type of \code{data}; one of \code{"json"} or a
value returned by \code{j_data_type()}; schema validation does not
support \code{"ndjson"} data.}

\item{schema_type}{character(1) type of \code{schema}; see \code{data_type}.}

\item{as}{for \code{j_schema_validate()}, one of \code{"string"}, \code{"R"},
\code{"data.frame"}, \code{"tibble"}, or \code{"details"}, to determine the
representation of the return value.}
}
\description{
\code{j_schema_is_vaild()} uses JSON Schema
\url{https://json-schema.org/} to validate JSON 'data' according to
'schema'.

\code{j_schema_validate()} returns a JSON or \emph{R} object,
data.frame, or tibble, describing how \code{data} does not conform
to \code{schema}. See the "Using 'jsoncons' in R" vignette for help
interpreting validation results.
}
\examples{
## Allowable `data_type=` and `schema_type` -- excludes 'ndjson'
j_data_type() |>
    Filter(\(type) !"ndjson" \%in\% type, x = _) |>
    str()
## compare JSON patch to specification. 'op' key should have value
## 'add'; 'paths' key should be key 'path'
## schema <- "https://json.schemastore.org/json-patch.json"
schema <- system.file(package = "rjsoncons", "extdata", "json-patch.json")
op <- '[{
    "op": "adds", "paths": "/biscuits/1",
    "value": { "name": "Ginger Nut" }
}]'
j_schema_is_valid(op, schema)

j_schema_validate(op, schema, as = "details")

}
