% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rprobdist.R
\name{rprobdist}
\alias{rprobdist}
\title{Generate a joint (or conditional) probability distribution}
\usage{
rprobdist(dim, d, cond, alpha = 1)
}
\arguments{
\item{dim}{the joint dimension of the probability table}

\item{d}{number of dimensions}

\item{cond}{optionally, vertices to condition upon}

\item{alpha}{Dirichlet hyper parameter, defaults to 1 (flat density).}
}
\value{
an array of appropriate dimensions
}
\description{
Wrapper functions to quickly generate discrete joint
(or conditional) distributions using Dirichlets
}
\details{
\code{rprobdist} gives an array of dimension \code{dim}
(recycled as necessary to have length \code{d}, if this is
supplied) whose entries are probabilities drawn from a Dirichlet
distribution whose parameter vector has entries equal to
\code{alpha} (appropriately recycled).
}
\section{Side Effects}{

Uses as many gamma random variables as cells
in the table, so will alter the random seed accordingly.
}

\examples{
rprobdist(2, 4)     # 2x2x2x2 table
rprobdist(c(2,3,2)) # 2x3x2 table

rprobdist(2, 4, alpha=1/16)     # using unit information prior

# get variables 2 and 4 conditioned upon
rprobdist(2, 4, cond=c(2,4), alpha=1/16) 

}
\author{
Robin Evans
}
\keyword{distribution}
