% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segs_direction.R
\name{showends}
\alias{showends}
\title{Identify Vertex Coordinates of Segment Endpoints}
\usage{
showends(seg, rivers)
}
\arguments{
\item{seg}{The segment (number) to check}

\item{rivers}{The river network object to use}
}
\description{
Identifies the vertex coordinates (row numbers) of the endpoints
  of a given segment.  The main purpose is determining which of the endpoints
  is the mouth (or lowest point) of the river system.
}
\note{
This function is called within \link{cleanup}, which is recommended in most cases.
}
\examples{
data(Gulk)

# say we know that segment 1 is the lowest segment in this river network, but we don't know 
# which end is the mouth.
showends(seg=1, rivers=Gulk)

# this means that the mouth is row 1, so we can specify this:
Gulk <- setmouth(seg=1, vert=1, rivers=Gulk)
}
\author{
Matt Tyers
}
