% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segs_direction.R
\name{mapbyname}
\alias{mapbyname}
\title{Map Segments by Name}
\usage{
mapbyname(rivers, scale = TRUE, cex = 0.6, ...)
}
\arguments{
\item{rivers}{The river network object to use.  Function checks segment names
contained in the river network object.}

\item{scale}{Whether or not to give x- and y-axes the same scale}

\item{cex}{Global character expansion factor for plotting}

\item{...}{Additional plotting arguments (see \link[graphics]{par})}
}
\description{
Provides a check that river network segments were appropriately
  named.
}
\examples{
data(Gulk)
str(Gulk)

Gulk$names <- c("Gulkana River","Trib 1","West Fork","Gulkana River","Trib 1",
                "West Fork","Trib 2","West Fork","Twelvemile Creek","Gulkana River",
                "Middle Fork","Gulkana River","Middle Fork","Hungry Hollow")
str(Gulk)

mapbyname(rivers=Gulk)
}
\author{
Matt Tyers
}
