% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/chapters-auto.R
\name{ch17}
\alias{ch17}
\title{Print examples of chapter 17 of 'R for Dummies'.}
\usage{
ch17()
}
\description{
To print a listing of all examples of a chapter, use \code{ch17()}. To run all the examples of \code{ch17()}, use \code{example(ch17)}.
}
\examples{
# Chapter 17 - Creating Faceted Graphics with Lattice


# Creating a Lattice Plot

str(mtcars)

## Loading the lattice package

library("lattice")

## Making a lattice scatterplot

xyplot(mpg ~ hp | factor(cyl), data=mtcars)

## Adding trend lines

xyplot(mpg ~ hp | factor(cyl), data=mtcars,
   type=c("p", "r"))


# Changing Plot Options

## Adding titles and labels

xyplot(mpg ~ hp | factor(cyl), data=mtcars,
   type=c("p", "r"),
   main="Fuel economy vs. Performance",
   xlab="Performance (horse power)",
   ylab="Fuel economy (miles per gallon)",
)

xyplot(mpg ~ hp | factor(cyl), data=mtcars,
   type=c("p", "r"),
   main=list(
       label="Fuel economy vs. Performance given Number of Cylinders",
       cex=0.75)
)

## Changing the font size of titles and labels

xyplot(mpg ~ hp | factor(cyl), data=mtcars,
   type=c("p", "r"),
   main=list(
       label="Fuel economy vs. Performance given Number of Cylinders",
       cex=0.75),
   xlab=list(
       label="Performance (horse power)",
       cex=0.75),
   ylab=list(
       label="Fuel economy (miles per gallon)",
       cex=0.75),
   scales=list(cex=0.5)
)


## Using themes to modify plot options

xyplot(mpg ~ hp | factor(cyl), data=mtcars,
   type=c("p", "r"),
   par.settings=simpleTheme(col="red", col.line="blue")
)


# Plotting Different Types

## Making a bar chart

mtcars$cars <- rownames(mtcars)

barchart(cars ~ mpg | factor(cyl), data=mtcars,
   main="barchart",
   scales=list(cex=0.5),
   layout=c(3, 1)
)

## Making a box-and-whisker plot

bwplot(~ hp | factor(cyl), data=mtcars, main="bwplot")


# Plotting Data in Groups

## Using data in tall format

str(longley)
library("reshape2")
mlongley <- melt(longley, id.vars="Year")

str(mlongley)

xyplot(value ~ Year | variable, data=mlongley,
   layout=c(6, 1),
   par.strip.text=list(cex=0.7),
   scales=list(cex=0.7)
)

## Creating a chart with groups

mtcars$cars <- rownames(mtcars)
mtcars$am <- with(mtcars, ifelse(am==0, "Automatic", "Manual"))

barchart(cars ~ mpg | factor(cyl), data=mtcars,
   group=am,
   scales=list(cex=0.5),
   layout=c(3, 1),
)

## Adding a key

barchart(cars ~ mpg | factor(cyl), data=mtcars,
   main="barchart with groups",
   group=am,
   auto.key=TRUE,
   par.settings = simpleTheme(col=c("grey80", "grey20")),
   scales=list(cex=0.5),
   layout=c(3, 1)
)


# Printing and Saving a Lattice Plot

## Assigning a lattice plot to an object

my.plot <- xyplot(mpg ~ hp | cyl, data=mtcars)
class(my.plot)

## Printing a lattice plot in a script

xyplot(mpg ~ hp | cyl, data=mtcars)

my.plot <- xyplot(mpg ~ hp | cyl, data=mtcars)
print(my.plot)


## Saving a lattice plot to file

setwd("~/")
\dontrun{
trellis.device(device="png", filename="xyplot.png")
}
print(my.plot)
\dontrun{
dev.off()
}

}
\seealso{
\code{\link{toc}}

Other Chapters: \code{\link{ch01}}, \code{\link{ch01}},
  \code{\link{ch1}}; \code{\link{ch02}},
  \code{\link{ch02}}, \code{\link{ch2}};
  \code{\link{ch03}}, \code{\link{ch03}},
  \code{\link{ch3}}; \code{\link{ch04}},
  \code{\link{ch04}}, \code{\link{ch4}};
  \code{\link{ch05}}, \code{\link{ch05}},
  \code{\link{ch5}}; \code{\link{ch06}},
  \code{\link{ch06}}, \code{\link{ch6}};
  \code{\link{ch07}}, \code{\link{ch07}},
  \code{\link{ch7}}; \code{\link{ch08}},
  \code{\link{ch08}}, \code{\link{ch8}};
  \code{\link{ch09}}, \code{\link{ch09}},
  \code{\link{ch9}}; \code{\link{ch10}};
  \code{\link{ch11}}; \code{\link{ch12}};
  \code{\link{ch13}}; \code{\link{ch14}};
  \code{\link{ch15}}; \code{\link{ch16}};
  \code{\link{ch18}}; \code{\link{ch19}};
  \code{\link{ch20}}
}

