% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seed.R
\name{py_set_seed}
\alias{py_set_seed}
\title{Set Python and NumPy random seeds}
\usage{
py_set_seed(seed, disable_hash_randomization = TRUE)
}
\arguments{
\item{seed}{A single value, interpreted as an integer}

\item{disable_hash_randomization}{Disable hash randomization, which is
another common source of variable results. See
\url{https://docs.python.org/3.4/using/cmdline.html#envvar-PYTHONHASHSEED}}
}
\description{
Set various random seeds required to ensure reproducible results. The
provided \code{seed} value will establish a new random seed for Python and NumPy,
and will also (by default) disable hash randomization.
}
\details{
This function does not set the R random seed, for that you
should call \code{\link[=set.seed]{set.seed()}}.
}
