% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{flowthrough_sim.rd}
\alias{flowthrough_sim.rd}
\title{Flowthrough respirometry data with increasing background rate}
\format{
A data frame object consisting of 3740 rows (approx 62 mins of
data),and 4 columns: time (col 1), specimen oxygen outflow concentrations
(col 2), control/blank chamber oxygen outflow concentrations (col 3), and
inflow concentrations recorded from a shared header tank (col 4).
}
\usage{
flowthrough_sim.rd
}
\description{
A simulated dataset for testing and demonstrating flowthrough respirometry
analyses and background adjustment when the background respiration rate
increases over the course of the experiment. Contains one column of numeric
time data (\verb{$num.time}), one column of specimen outflow oxygen concentrations
(\verb{$oxy.out.spec}), one column of control or "blank" chamber outflow oxygen
concentrations (\verb{$oxy.out.blank}), and one column of inflow oxygen
concentrations as recorded from a shared header tank (\verb{$oxy.header})
supplying both chambers.
}
\details{
\itemize{
\item Dissolved oxygen units: \code{mg/L}
\item Time units: \code{seconds}
}
}
\author{
Nicholas Carey
}
\keyword{datasets}
