% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_spec.R
\name{page_header}
\alias{page_header}
\title{Add a page header}
\usage{
page_header(x, left = "", right = "", blank_row = "none")
}
\arguments{
\item{x}{The report object.}

\item{left}{The left page header text.  May be a single string or a vector
of strings.}

\item{right}{The right page header text.  May be a single string or a vector
of strings.}

\item{blank_row}{Whether to create a blank row below the page header.
Valid values are 'below' and 'none'.  Default is 'none'.}
}
\value{
The modified report specification.
}
\description{
This function adds a page header to the report.  The page header will appear
at the top of each page of the report.
}
\details{
The page header may contain text on the left or right. Use the appropriate
parameters to specify the desired text.  Only one page header is allowed
on a report. The page header will be repeated on every page of the report.
Multiple text values for each side
may be specified as a vector of strings.  

If the width of the page header
string exceeds the available space, an error will be generated. There is 
also a limit of 5 page header strings per each side.

There are two special tokens to generate page numbers: [pg] and [tpg]. 
Use [pg] to indicate the current page number.  Use [tpg] to indicate the
total number of pages in the report.  These tokens may be placed anywhere 
in the page header or page footer. 

Each header string must fit within the available space.  The \strong{reporter}
package will not wrap headers.  If a header string does not fit within the 
available space, an error will be generated.  In these situations, either
shorten the header string or split it into multiple headers that each fit 
within the available space.
}
\examples{
library(magrittr)

# Create temp file path
tmp <- file.path(tempdir(), "mtcars.txt")

dat <- data.frame(name = rownames(mtcars[1:10, ]), mtcars[1:10, 1:5])

# Create the report object
rpt <- create_report(tmp, orientation = "portrait") \%>\% 
  page_header("Client: Motor Trend", "Study: Cars") \%>\% 
  titles("MTCARS Sample Report") \%>\% 
  add_content(create_table(dat)) \%>\% 
  page_footer(Sys.time(), right = "Page [pg] of [tpg]")

# Write the report to the file system
write_report(rpt)

# Write report to console
writeLines(readLines(tmp, encoding = "UTF-8"))

# Client: Motor Trend                                                Study: Cars
#                              MTCARS Sample Report
# 
#                name                 mpg cyl   disp   hp  drat
#                ----------------------------------------------
#                Mazda RX4             21   6    160  110   3.9
#                Mazda RX4 Wag         21   6    160  110   3.9
#                Datsun 710          22.8   4    108   93  3.85
#                Hornet 4 Drive      21.4   6    258  110  3.08
#                Hornet Sportabout   18.7   8    360  175  3.15
#                Valiant             18.1   6    225  105  2.76
#                Duster 360          14.3   8    360  245  3.21
#                Merc 240D           24.4   4  146.7   62  3.69
#                Merc 230            22.8   4  140.8   95  3.92
#                Merc 280            19.2   6  167.6  123  3.92
# 
# ...
# 
# 2020-10-17 11:53:51                                                Page 1 of 1
}
\seealso{
Other report: 
\code{\link{add_content}()},
\code{\link{create_report}()},
\code{\link{footnotes}()},
\code{\link{options_fixed}()},
\code{\link{page_by}()},
\code{\link{page_footer}()},
\code{\link{print.report_spec}()},
\code{\link{set_margins}()},
\code{\link{title_header}()},
\code{\link{titles}()},
\code{\link{write_report}()}
}
\concept{report}
