% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imbue.R
\name{imbue}
\alias{imbue}
\title{Imbue an renv Installation}
\usage{
imbue(project = NULL, version = NULL, quiet = FALSE)
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}

\item{version}{The version of \code{renv} to install. If \code{NULL}, the version
of \code{renv} currently installed will be used. The requested version of
\code{renv} will be retrieved from the \code{renv} public GitHub repository,
at \url{https://github.com/rstudio/renv}.}

\item{quiet}{Boolean; avoid printing output during install of \code{renv}?}
}
\value{
The project directory, invisibly. Note that this function is normally
called for its side effects.
}
\description{
Imbue an \code{renv} installation into a project, thereby making the requested
version of \code{renv} available within.
}
\details{
Normally, this function does not need to be called directly by the user; it
will be invoked as required by \code{\link[=init]{init()}} and \code{\link[=activate]{activate()}}.
}
