% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EOO_functions.R
\name{getAreaEOO}
\alias{getAreaEOO}
\title{Calculates area of the created EOO polygon.}
\usage{
getAreaEOO(EOO.polygon)
}
\arguments{
\item{EOO.polygon}{An object of class SpatialPolygons, usually the output
from \code{makeEOO}.}
}
\value{
The area of the \code{EOO.polygon} in km2
}
\description{
\code{getAreaEOO} calculates the area of the EOO polygon generated from
\code{makeEOO} the provided data
}
\examples{
crs.UTM55S <- '+proj=utm +zone=55 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs'
r1 <- raster(ifelse((volcano<130), NA, 1), crs = crs.UTM55S)
extent(r1) <- extent(0, 6100, 0, 8700)
EOO.polygon <- makeEOO(r1)
EOO.area <- getAreaEOO(EOO.polygon)
}
\seealso{
Other EOO functions: \code{\link{makeEOO}}
}
\author{
Nicholas Murray \email{murr.nick@gmail.com}, Calvin Lee
  \email{calvinkflee@gmail.com}
}
