% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearestobs.R
\name{nearestobs}
\alias{nearestobs}
\title{Nearest species sightings}
\usage{
nearestobs(species, lat = NULL, lng = NULL, back = NULL, max = NULL,
  locale = NULL, provisional = FALSE, hotspot = FALSE, sleep = 0, ...)
}
\arguments{
\item{species}{(required) Scientific name of the species of interest (not case
sensitive). See eBird taxonomy for more information:
http://ebird.org/content/ebird/about/ebird-taxonomy}

\item{lat}{Decimal latitude. value between -90.00 and 90.00, up to two
decimal places of precision. Defaults to latitude basd on IP.}

\item{lng}{Decimal longitude. value between -180.00 and 180.00, up to
two decimal places of precision. Defaults to longitude basd on IP.}

\item{back}{Number of days back to look for observations (between
1 and 30, defaults to 14).}

\item{max}{Maximum number of result rows to return in this request
(between 1 and 10000, defaults to all).}

\item{locale}{Language/locale of response (when translations are available).
See http://java.sun.com/javase/6/docs/api/java/util/Locale.html
(defaults to en_US).}

\item{provisional}{Should flagged records that have not been reviewed
be included? (defaults to FALSE).}

\item{hotspot}{Should results be limited to sightings at birding hotspots?
(defaults to FALSE).}

\item{sleep}{Time (in seconds) before function sends API call (defaults to
zero. Set to higher number if you are using this function in a loop with
many API calls).}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
A data.frame containing the collected information:

"comName": species common name

"howMany": number of individuals observed, NA if only presence was noted

"lat": latitude of the location.

"lng": longitude of the location.

"locID": unique identifier for the location

"locName": location name

"locationPrivate": TRUE if location is not a birding hotspot

"obsDt": observation date formatted according to ISO 8601
   (e.g. 'YYYY-MM-DD', or 'YYYY-MM-DD hh:mm'). Hours and minutes are excluded
   if the observer did not report an observation time.

"obsReviewed": TRUE if observation has been reviewed, FALSE otherwise

"obsValid": TRUE if observation has been deemed valid by either the
   automatic filters or a regional viewer, FALSE otherwise

"sciName" species' scientific name
}
\description{
Returns the most recent and nearest reported sighting information
with observations of a species.
}
\examples{
\dontrun{
nearestobs('branta canadensis', 42, -76)
nearestobs('branta canadensis', 42, -76, max=10, provisional=TRUE, hotspot=TRUE)
}
}
\references{
\url{http://ebird.org/}
}
\author{
Rafael Maia \email{rm72@zips.uakron.edu}
}
