% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_analysis.R
\name{rba_reactome_analysis_mapping}
\alias{rba_reactome_analysis_mapping}
\title{Maps Molecule Identifiers}
\usage{
rba_reactome_analysis_mapping(
  input,
  input_format = NULL,
  projection = FALSE,
  interactors = FALSE,
  ...
)
}
\arguments{
\item{input}{A vector, local file path or URL that points to your
identifiers list.}

\item{input_format}{(Optional) This function will automatically identify
your supplied input's format. But in case of unexpected issues or if you
want to be explicit, set this argument to one of:\itemize{
\item "vector": If you supplied a simple vector (numeric or character) as
input.
\item "file": If you supplied a local file path pointing to a
correctly-formatted text file.
\item "url": If you supplied a URL pointing to a correctly-formatted
text file.}}

\item{projection}{Logical (default = FALSE) Should non-human identifiers
be projected to their human equivalents? (using Reactome orthology data)}

\item{interactors}{Logical (default = FALSE) Should IntAct interaction data
be included?}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
List containing your identifiers and the IDS and resources they
  are mapped to.
}
\description{
Use this function to map molecule identifiers of different species to
  Reactome Identifiers.
}
\section{Corresponding API Resources}{

"GET https://reactome.org/AnalysisService/mapping"
\cr "GET https://reactome.org/AnalysisService/mapping/form"
\cr "GET https://reactome.org/AnalysisService/mapping/form/projection"
\cr "GET https://reactome.org/AnalysisService/mapping"
\cr "GET https://reactome.org/AnalysisService/mapping/url"
\cr "GET https://reactome.org/AnalysisService/mapping/url/projection"
}

\examples{
\donttest{
rba_reactome_analysis_mapping(c("Q8SQ34", "cd40"))
}

}
\references{
\itemize{
  \item Marc Gillespie, Bijay Jassal, Ralf Stephan, Marija Milacic, Karen
  Rothfels, Andrea Senff-Ribeiro, Johannes Griss, Cristoffer Sevilla, Lisa
  Matthews, Chuqiao Gong, Chuan Deng, Thawfeek Varusai, Eliot Ragueneau,
  Yusra Haider, Bruce May, Veronica Shamovsky, Joel Weiser, Timothy Brunson,
  Nasim Sanati, Liam Beckman, Xiang Shao, Antonio Fabregat, Konstantinos
  Sidiropoulos, Julieth Murillo, Guilherme Viteri, Justin Cook, Solomon
  Shorser, Gary Bader, Emek Demir, Chris Sander, Robin Haw, Guanming Wu,
  Lincoln Stein, Henning Hermjakob, Peter D’Eustachio, The reactome
  pathway knowledgebase 2022, Nucleic Acids Research, 2021;, kab1028,
  https://doi.org/10.1093/nar/gkab1028
  \item Griss J, Viteri G, Sidiropoulos K, Nguyen V, Fabregat A,
  Hermjakob H. ReactomeGSA - Efficient Multi-Omics Comparative Pathway
  Analysis. Mol Cell Proteomics. 2020 Sep 9. doi: 10.1074/mcp. PubMed
  PMID: 32907876.
  \item \href{https://reactome.org/AnalysisService/}{Reactome Analysis
  Services API Documentation}
  \item \href{https://reactome.org/cite}{Citations note on Reactome website}
  }
}
\seealso{
Other "Reactome Analysis Service": 
\code{\link{rba_reactome_analysis_download}()},
\code{\link{rba_reactome_analysis_import}()},
\code{\link{rba_reactome_analysis_pdf}()},
\code{\link{rba_reactome_analysis_species}()},
\code{\link{rba_reactome_analysis_token}()},
\code{\link{rba_reactome_analysis}()}
}
\concept{"Reactome Analysis Service"}
