% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaspar.R
\name{rba_jaspar_matrix_search}
\alias{rba_jaspar_matrix_search}
\title{Search matrix profiles available in JASPAR}
\usage{
rba_jaspar_matrix_search(
  term = NULL,
  tf_name = NULL,
  tf_class = NULL,
  tf_family = NULL,
  tax_group = NULL,
  tax_id = NULL,
  data_type = NULL,
  collection = NULL,
  release = 2020,
  only_last_version = FALSE,
  order = NULL,
  page_size = 1000,
  page = 1,
  ...
)
}
\arguments{
\item{term}{Character: A search term.}

\item{tf_name}{Character: Transcription factor names (Case-sensitive).}

\item{tf_class}{Character: Transcription factor class}

\item{tf_family}{Character: Transcription factor family}

\item{tax_group}{Character: Taxonomic group. Use
\code{\link{rba_jaspar_taxons}} to get a list of supported Taxonomic
groups.}

\item{tax_id}{Numeric: NCBI taxonomic Identifier of species. Use
\code{\link{rba_jaspar_species}} to get a list of supported Species.}

\item{data_type}{Character: Type of the data (i.e The Methodology used
for matrix construction). For example: "ChIP-seq", "PBM"}

\item{collection}{Character: JASPAR matrix profile collection name. USE
\code{\link{rba_jaspar_collections}} to get a list of collection names.}

\item{release}{Numeric: (default = 2020) Which JASPAR database release
to use? Available options are: 2014, 2016, 2018, and 2020.}

\item{only_last_version}{Logical: (default = FALSE) If TRUE, only the
latest version of a matrix profile will be returned.}

\item{order}{Character: A character string or a vector of character strings
of field names that will be used to order the results.
\cr Providing multiple field names is supported. You can also use prefix
"-" before a field name to indicate reverse ordering.}

\item{page_size}{Numeric: (default = 1000) This resource returns paginated
results. What is the maximum numbers of results that you want to retrieve
per a page? Accepted values are between 1 and 1000.}

\item{page}{Numeric: Which page of the results to retrieve? The accepted
values depend on the page size and number of results.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list that contains a data frame of matrix profiles' information.
}
\description{
You can use this function to list the JASPAR matrix
  profiles that match your search query, or run the function without any
  arguments to return a list of every matrix profile available in the
  latest release.
}
\details{
Note that this is a search function. Thus, you are not required to fill
  every argument; You may use whatever combinations of arguments you see
  fit for your query.
  \cr The results are paginated. You can control the page's size number
  with the function's arguments. Also, you can use \code{\link{rba_pages}}
  to automatically iterate over multiple pages.
}
\section{Corresponding API Resources}{

 "GET "http://jaspar.genereg.net/api/v1/api/v1/matrix/"
}

\examples{
\donttest{
rba_jaspar_matrix_search(term = "FOX")
rba_jaspar_matrix_search(tf_name = "FOXP3")
rba_jaspar_matrix_search(tf_name = "FOXP3", only_last_version = TRUE)
rba_jaspar_matrix_search(tf_class = "Zipper-Type")
rba_jaspar_matrix_search(tax_group = "insects")
rba_jaspar_matrix_search(page_size = 100)
}

}
\references{
\itemize{
  \item Fornes O, Castro-Mondragon JA, Khan A, et al. JASPAR 2020: update
    of the open-access database of transcription factor binding profiles.
    Nucleic Acids Res. 2019; doi: 10.1093/nar/gkz1001
  \item Khan, A. and Mathelier, A. JASPAR RESTful API: accessing JASPAR
    data from any programming language. Bioinformatics, 2017, doi:
    10.1093/bioinformatics/btx804
  \item Khan, A. et al. JASPAR 2018: update of the open-access database
    of transcription factor binding profiles and its web framework.
    Nucleic Acids Res. 2018; 46:D260–D266, doi: 10.1093/nar/gkx1126
  \item
  \href{http://jaspar.genereg.net/api/v1/docs/}{JASPAR API Documentation}
  }
}
\seealso{
Other "JASPAR": 
\code{\link{rba_jaspar_collections_matrices}()},
\code{\link{rba_jaspar_collections}()},
\code{\link{rba_jaspar_matrix_versions}()},
\code{\link{rba_jaspar_matrix}()},
\code{\link{rba_jaspar_releases}()},
\code{\link{rba_jaspar_sites}()},
\code{\link{rba_jaspar_species_matrices}()},
\code{\link{rba_jaspar_species}()},
\code{\link{rba_jaspar_taxons_matrices}()},
\code{\link{rba_jaspar_taxons}()},
\code{\link{rba_jaspar_tffm_search}()},
\code{\link{rba_jaspar_tffm}()}
}
\concept{"JASPAR"}
