% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libbi.R
\name{add_output}
\alias{add_output}
\alias{add_output.libbi}
\title{Add output file to a \code{\link{libbi}} object}
\usage{
\method{add_output}{libbi}(x, output, ...)
}
\arguments{
\item{x}{a \code{\link{libbi}} object}

\item{output}{name of the file to add as output file, or a list of data frames that contain the outputs}

\item{...}{ignored}
}
\description{
Adds an output file to a \code{\link{libbi}} object. This is useful to recreate a \code{\link{libbi}} object from the model and output files of a previous run
}
\examples{
bi <- libbi(model = system.file(package="rbi", "PZ.bi"))
example_output_file <- system.file(package="rbi", "example_output.nc")
bi <- add_output(bi, example_output_file)
}

