% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgl.R
\name{rgl-call}
\alias{rgl-call}
\alias{rgl_call}
\alias{rgl_view}
\alias{rgl_plot_normals}
\title{Safe ways to call package \code{'rgl'} without requiring \code{'x11'}}
\usage{
rgl_call(FUN, ...)

rgl_view(expr, quoted = FALSE, env = parent.frame())

rgl_plot_normals(x, length = 1, lwd = 1, col = 1, ...)
}
\arguments{
\item{FUN}{\code{'rgl'} function name}

\item{...}{passed to \code{'rgl'} function}

\item{expr}{expression within which \code{'rgl'} functions are called}

\item{quoted}{whether \code{expr} is quoted}

\item{env}{environment in which \code{expr} is evaluated}

\item{x}{triangular \code{'mesh3d'} object}

\item{length, lwd, col}{normal vector length, size, and color}
}
\description{
Internally used for example show-cases. Please install package \code{'rgl'}
manually to use these functions.
}
\examples{


# Make sure the example does not run when compiling
# or check the package
if(FALSE) {

  volume <- array(0, dim = c(8,8,8))
  volume[4:5, 4:5, 4:5] <- 1
  mesh <- mesh_from_volume(volume, verbose = FALSE)

  rgl_view({

    rgl_call("shade3d", mesh, col = 3)
    rgl_plot_normals(mesh)

  })

}


}
