% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/okabeito-color-scales.R
\name{scale_colour_okabeito}
\alias{scale_colour_okabeito}
\alias{scale_color_okabeito}
\alias{scale_fill_okabeito}
\alias{scale_okabeito}
\title{Okabe-Ito color scale}
\arguments{
\item{...}{common discrete scale parameters: \code{name}, \code{breaks}, \code{labels},
\code{na.value}, \code{limits}, \code{guide}, and \code{aesthetics}. See \link[ggplot2:discrete_scale]{ggplot2::discrete_scale} for
more details.}

\item{use_black}{If \code{TRUE}, scale includes black, otherwise includes gray.}

\item{order}{Numeric vector listing the order in which the colors should be
used. Default is 1:8.}

\item{darken}{Relative amount by which the scale should be darkened (for
positive values) or lightened (for negative values).}

\item{alpha}{Alpha transparency level of the color. Default is no
transparency.}
}
\value{
A color scale for use in plots created with \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
This is a color-blind friendly, qualitative scale with eight different
colors. See \link{palette_okabeito} for details.
}
\examples{
library(ggplot2)
ggplot(iris, aes(Sepal.Length, Sepal.Width, color = Species)) +
  geom_point() + scale_color_okabeito()
ggplot(iris, aes(Sepal.Length, fill = Species)) +
  geom_density(alpha = 0.7) + scale_fill_okabeito(order = c(1, 3, 5))
}
