% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RapUnsolved.R
\name{RapUnsolved}
\alias{RapUnsolved}
\title{Create a new RapUnsolved object}
\usage{
RapUnsolved(opts, data)
}
\arguments{
\item{opts}{\code{\link{RapReliableOpts}} or \code{\link{RapUnreliableOpts}}
object.}

\item{data}{\code{\link{RapData}} object.}
}
\value{
\code{\link{RapUnsolved}} object.
}
\description{
This function creates a \code{\link{RapUnsolved}} object using a
\code{\link{GurobiOpts}}, a \code{\link{RapReliableOpts}} or
\code{\link{RapUnreliableOpts}} object, and a \code{\link{RapData}} object.
}
\examples{
\donttest{
# set random number generator seed
set.seed(500)

# load data
data(cs_pus, cs_spp)

# create inputs for RapUnsolved
ro <- RapUnreliableOpts()
rd <- make.RapData(cs_pus[seq_len(10), ], cs_spp, NULL,
                   include.geographic.space = TRUE,n.demand.points = 5L)

# create RapUnsolved object
ru <- RapUnsolved(ro, rd)

# print object
print(ru)
}
}
\seealso{
\code{\link{RapReliableOpts-class}},
  \code{\link{RapUnreliableOpts-class}}, \code{\link{RapData-class}}.
}
