% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverGraph.R
\name{coverGraph}
\alias{coverGraph}
\title{Compute the cover graph of order generated by intervals}
\usage{
coverGraph(intervals, names = NULL)
}
\arguments{
\item{intervals}{data frame (see \link{generateIntervals} for
the required format)}

\item{names}{names of intervals (\code{1:nrow(intervals)} by default)}
}
\value{
A list of edges of the cover graph.
}
\description{
The cover graph of the order generated by a set of intervals is the minimal
graph whose reachability relation is that order.
}
\details{
See section 6 of Rising (2021).
}
\examples{
left <- sort(c(1:3, 1:3 + 0.1))
right <- left + 0.7
intervals <- data.frame(left = left, right = right)
coverGraph(intervals)

}
\references{
Rising, Justin (2021).  \emph{Uncertainty in Ranking}.  arXiv:2107.03459.
}
