% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic.R
\name{summary.logistic}
\alias{summary.logistic}
\title{Summary method for the logistic function}
\usage{
\method{summary}{logistic}(object, sum_check = "", conf_lev = 0.95,
  test_var = "", dec = 3, ...)
}
\arguments{
\item{object}{Return value from \code{\link{logistic}}}

\item{sum_check}{Optional output. "vif" to show multicollinearity diagnostics. "confint" to show coefficient confidence interval estimates. "odds" to show odds ratios and confidence interval estimates.}

\item{conf_lev}{Confidence level to use for coefficient and odds confidence intervals (.95 is the default)}

\item{test_var}{Variables to evaluate in model comparison (i.e., a competing models Chi-squared test)}

\item{dec}{Number of decimals to show}

\item{...}{further arguments passed to or from other methods}
}
\description{
Summary method for the logistic function
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/logistic.html} for an example in Radiant
}
\examples{
result <- logistic(titanic, "survived", "pclass", lev = "Yes")
summary(result, test_var = "pclass")
res <- logistic(titanic, "survived", c("pclass", "sex"), int = "pclass:sex", lev = "Yes")
summary(res, sum_check = c("vif", "confint", "odds"))
titanic \%>\% logistic("survived", c("pclass", "sex", "age"), lev = "Yes") \%>\% summary("vif")

}
\seealso{
\code{\link{logistic}} to generate the results

\code{\link{plot.logistic}} to plot the results

\code{\link{predict.logistic}} to generate predictions

\code{\link{plot.model.predict}} to plot prediction output
}
