% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naivebayes.R
\name{store.nb.predict}
\alias{store.nb.predict}
\title{Store predicted values generated in the nb function}
\usage{
\method{store}{nb.predict}(object, ..., data = attr(object, "pred_data"),
  name = "")
}
\arguments{
\item{object}{Return value from model function}

\item{...}{Additional arguments}

\item{data}{Data or dataset name (e.g., data = mtcars or data = "mtcars")}

\item{name}{Variable name(s) assigned to predicted values. If empty, the levels of the response variable will be used}
}
\description{
Store predicted values generated in the nb function
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/nb.html} for an example in Radiant
}
\examples{
result <- nb("titanic", "survived", c("pclass","sex","age"))
pred <- predict(result, pred_data = "titanic")
store(pred, data = titanic, name = "pred") \%>\% head
store(pred, data = titanic) \%>\% head

}
