% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\name{set_fare_structure}
\alias{set_fare_structure}
\title{Set the fare structure used when calculating transit fares}
\usage{
set_fare_structure(r5r_core, fare_structure)
}
\arguments{
\item{r5r_core}{An object to connect with the R5 routing engine, created with
\code{\link[=setup_r5]{setup_r5()}}.}

\item{fare_structure}{A fare structure object, following the convention
set in \code{\link[=setup_fare_structure]{setup_fare_structure()}}. This object describes how transit fares
should be calculated. Please see the fare structure vignette to
understand how this object is structured:
\code{vignette("fare_structure", package = "r5r")}.}
}
\value{
Invisibly returns \code{TRUE}.
}
\description{
Sets the fare structure used by our "generic" fare calculator. A value of
\code{NULL} is passed to \code{fare_structure} by the upstream routing and
accessibility functions when fares are not to be calculated.
}
\seealso{
Other setting functions: 
\code{\link{set_breakdown}()},
\code{\link{set_cutoffs}()},
\code{\link{set_expanded_travel_times}()},
\code{\link{set_fare_cutoffs}()},
\code{\link{set_max_fare}()},
\code{\link{set_max_lts}()},
\code{\link{set_max_rides}()},
\code{\link{set_monte_carlo_draws}()},
\code{\link{set_n_threads}()},
\code{\link{set_output_dir}()},
\code{\link{set_percentiles}()},
\code{\link{set_progress}()},
\code{\link{set_speed}()},
\code{\link{set_suboptimal_minutes}()},
\code{\link{set_time_window}()},
\code{\link{set_verbose}()}
}
\concept{setting functions}
\keyword{internal}
