% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/rd.R, R/remove.R
\name{m_add_unit_cell}
\alias{m_add_unit_cell}
\alias{m_replicate_unit_cell}
\alias{m_unit_cell}
\alias{m_remove_unit_cell}
\title{Unit cell visualization}
\usage{
m_add_unit_cell(id, model, spec)

m_replicate_unit_cell(id, a, b, c, model)

m_remove_unit_cell(id, model)
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})}

\item{model}{Model with unit cell information (e.g., pdb derived).
If omitted uses most recently added model.}

\item{spec}{Visualization style.}

\item{a}{number of times to replicate cell in X dimension.}

\item{b}{number of times to replicate cell in Y dimension. If absent, X value
is used.}

\item{c}{number of times to replicate cell in Z dimension. If absent, Y value
is used.}
}
\value{
R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})
}
\description{
Use \code{\link{m_add_unit_cell}} to create and add unit cell visualization,
and \code{\link{m_remove_unit_cell}} to remove it from model. Use
\code{\link{m_replicate_unit_cell}} to replicate atoms in model to form a
super cell of the specified dimensions. Original cell will be centered as
much as possible.
}
\examples{
library(r3dmol)

# Create model
mol <- r3dmol() \%>\%
  m_add_model(
    data = cif_254385,
    "cif",
    options = list(doAssembly = TRUE, normalizeAssembly = TRUE)
  ) \%>\%
  m_set_style(style = list(
    sphere = list(colorscheme = "Jmol", scale = 0.25),
    stick = list(colorscheme = "Jmol")
  )) \%>\%
  m_add_unit_cell(spec = list(
    alabel = "x",
    blabel = "y",
    clabel = "z",
    box = list(hidden = TRUE)
  )) \%>\%
  m_zoom_to()

# Render model
mol

# Remove unit cell
mol \%>\%
  m_remove_unit_cell()

# Replicate atoms in model to form a super cell
r3dmol() \%>\%
  m_add_model(data = cif_254385, format = "cif") \%>\%
  m_set_style(style = list(sphere = list(scale = 0.25))) \%>\%
  m_add_unit_cell() \%>\%
  m_zoom_to() \%>\%
  m_replicate_unit_cell(a = 3, b = 2, c = 1)
}
