% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_id.R
\name{fetch_id}
\alias{fetch_id}
\title{Fetch a unique Qualtrics survey ID based on survey name in the Qualtrics UI}
\usage{
fetch_id(.data, survey_name, partial_match = FALSE)
}
\arguments{
\item{.data}{Data frame of active surveys created by the function
\code{\link[=all_surveys]{all_surveys()}}.}

\item{survey_name}{String. Name of the survey as it appears in the Qualtrics
UI. Must be unique to be passed to \code{fetch_id()}.}

\item{partial_match}{Boolean. Will match all surveys containing the exact
string provided.  Defaults to FALSE, which matches against the entire name.}
}
\description{
Fetch a unique Qualtrics survey ID based on survey name in the Qualtrics UI
}
\details{
Survey names in the Qualtrics platform are not required to be
unique, but the \code{survey_name} argument for this function \emph{must} be unique.
If input results in multiple surveys being matched, will error with a list
of up to 5 matches & their IDs
}
\examples{
\dontrun{
# Register your Qualtrics credentials if you haven't already
qualtrics_api_credentials(
  api_key = "<YOUR-API-KEY>",
  base_url = "<YOUR-BASE-URL>"
)

# Retrieve a list of surveys
surveys <- all_surveys()

# Retrieve surveyID for a unique survey
my_id <- fetch_id(surveys, "Unique Survey Name")

}
}
