% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_exposed_newborns.R
\name{time_exposed_newborns}
\alias{time_exposed_newborns}
\title{Data frame of time exposed at risk for a population of newborns}
\usage{
time_exposed_newborns(date.birth, random.b = TRUE)
}
\arguments{
\item{date.birth}{A character vector with the dates of birth in format either "yyyy-mm-dd" or "yyyy-mm-dd hour:min:secs" (for instance, "2016-01-20 12:00:00") of the members of the population.
If "hour:min:secs" is omitted the function imputes either "12:00:00", if `random.b = FALSE`, or
a random hour by default.}

\item{random.b}{A `TRUE/FALSE` argument indicating whether the exact moment ("hour:min:secs") when the birth occurs within the day is randomly selected. If TRUE, this overwrites "hour:min:secs" in `date.birth` even if those have been declared. By default, TRUE.}
}
\value{
A data frame with the time exposed at risk for each (potential) combination of integer age and age and
season quarter of the population. The data frame has the following components:
   \item{age}{ Integer age to which the time exposed at risk corresponds.}
   \item{quarter.age}{ Age quarter to which the time exposed at risk corresponds.}
   \item{quarter.calendar}{ Calendar (time, season) quarter to which the time exposed at risk corresponds.}
   \item{time.exposed}{ Total time (in years) exposed at risk of the population during the quarter determined for the
                        combination of `age`, `quarter.age` and `quarter.season`.}
}
\description{
Computes for each combination of age and seasonal quarter
              the total time exposed at risk (in years) of a population of newborns,
              during the year of their birth, this is up to the end of the year when they born.
}
\examples{
dates.b <- c("1920-05-13", "1999-04-12", "2019-01-01")
out <- time_exposed_newborns(dates.b)
}
\references{
Pavia, JM and Lledo, J (2022). Estimation of the Combined Effects of Ageing and Seasonality on Mortality Risk. An application to Spain. *Journal of the Royal Statistical Society, Series A (Statistics in Society)*, 185(2), 471-497. \doi{10.1111/rssa.12769}
}
\seealso{
\code{\link{time_exposed_stock}}, \code{\link{time_exposed_outs}}, \code{\link{time_exposed_ins}}
}
\author{
Jose M. Pavia \email{pavia@uv.es}

Josep Lledo \email{josep.lledo@uv.es}
}
