% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/dates.R
\name{advanceUnits_cpp}
\alias{advanceUnits_cpp}
\alias{advanceUnits}
\title{Compute adjusted dates}
\usage{
advanceUnits_cpp(dates, n, unit, bdc, emr)

advanceUnits(dates, n, unit = c("Days", "Weeks", "Months", "Years", "Hours",
  "Minutes", "Seconds", "Milliseconds", "Microseconds"), bdc = c("Following",
  "ModifiedFollowing", "Preceding", "ModifiedPreceding", "Unadjusted",
  "HalfMonthModifiedFollowing", "Nearest"), emr = FALSE)
}
\arguments{
\item{dates}{A Date vector with dates}

\item{n}{An integer variable with the number of units to advance}

\item{unit}{A character variable describing one of several supported values;
the C++ version implements expects a corresponding integer value}

\item{bdc}{A character variable describing one of several supported values,
the C++ version implements expects a corresponding integer value}

\item{emr}{A boolean variable select end-of-month, default is \sQuote{FALSE}}
}
\value{
A Date vector with dates advanced according to the selected inputs
}
\description{
Advance a vector of dates by a given number of time units
}
\details{
This function takes a vector of dates and returns another vector of dates
of the same length returning at each position the date advanced by the given
number of steps in the selected time unit, also respecting a business day
convention and and of month boolean switch. Currently supported values for
the time unit are \sQuote{Days}, \sQuote{Weeks}, \sQuote{Months} \sQuote{Years},
\sQuote{Hours}, \sQuote{Seconds}, \sQuote{Milliseconds} and \sQuote{Microseconds};
all are specified as integers. Note that intra-daily units are not currently
supported for advancing \sQuote{Date} objects. Currently supported values for
the business day convention are (starting from zero):
\sQuote{Following}, \sQuote{ModifiedFollowing}, \sQuote{Preceding},
\sQuote{ModifiedPreceding}, \sQuote{Unadjusted}, \sQuote{HalfModifiedFollowing}
and \sQuote{Nearest}.
}
\examples{
advanceUnits(Sys.Date()+0:6, 5, "Days", "Following")
}
