% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/502.Error-Failure_LimitBased_BASE_All_Graph.R
\name{PloterrEX}
\alias{PloterrEX}
\title{Plots error, long term power and pass/fail criteria using Exact method}
\usage{
PloterrEX(n, alp, phi, f, e)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{phi}{- Null hypothesis value}

\item{f}{- Failure criterion}

\item{e}{- Exact method indicator  in [0, 1] {1: Clopper Pearson, 0.5: Mid P}
The input can also be a range of values between 0 and 1.}
}
\description{
Plots error, long term power and pass/fail criteria using Exact method
}
\details{
Plots of Confidence interval for \code{p}
based on inverting equal-tailed binomial tests with null hypothesis \eqn{H0: p = p0}
using error due to the difference of achieved and nominal level of significance for the \eqn{n + 1} intervals
}
\examples{
n=20; alp=0.05;phi=0.05; f=-2;e=0.5 # Mid-p
PloterrEX(n,alp,phi,f,e)
n=20; alp=0.05;phi=0.05; f=-2;e=1 #Clopper-Pearson
PloterrEX(n,alp,phi,f,e)
n=20; alp=0.05;phi=0.05; f=-2;e=c(0.1,0.5,0.95,1) #Range including Mid-p and Clopper-Pearson
PloterrEX(n,alp,phi,f,e)
}
\seealso{
Other Error for base methods: \code{\link{PloterrAS}},
  \code{\link{PloterrAll}}, \code{\link{PloterrBA}},
  \code{\link{PloterrLR}}, \code{\link{PloterrLT}},
  \code{\link{PloterrSC}}, \code{\link{PloterrTW}},
  \code{\link{PloterrWD}}, \code{\link{errAS}},
  \code{\link{errAll}}, \code{\link{errBA}},
  \code{\link{errEX}}, \code{\link{errLR}},
  \code{\link{errLT}}, \code{\link{errSC}},
  \code{\link{errTW}}, \code{\link{errWD}}
}

