#' precrec: A package for computing accurate ROC and Precision-Recall curves
#'
#' The precrec package provides three categories of important functions:
#' performance measure calculations, S3 generics, and data preparation.
#'
#' @section Performance measure calculations:
#' The \code{\link{evalmod}} function calculates ROC and Precision-Recall
#'  curves and returns an S3 object. The generated S3 object can be used
#'  with several different S3 generics, such as \code{print} and
#'  \code{\link{plot}}. The \code{\link{evalmod}} function can also
#'  calculate basic evaluation measures - error rate, accuracy, specificity,
#'  sensitivity, and precision.
#'
#' @section S3 generics:
#' The precrec package provides five different S3 generics for the S3 objects
#'  generated by the \code{\link{evalmod}} function.
#'
#'   \tabular{lll}{
#'     \strong{S3 generic}
#'     \tab \tab \strong{Library} \cr
#'
#'     \code{print}           \tab \tab base \cr
#'     \code{\link{plot}}     \tab \tab graphics \cr
#'     \code{\link{autoplot}} \tab \tab ggplot2 \cr
#'     \code{\link{fortify}}  \tab \tab ggplot2 \cr
#'     \code{\link{auc}}      \tab \tab precrec
#'   }
#'
#' @section Data preparation:
#' The \code{\link{mmdata}} function creates an input dataset for
#'  the \code{\link{evalmod}} function. The generated dataset contains
#'  formatted scores and labels.
#'
#' \code{\link{join_scores}} and \code{\link{join_labels}} are helper
#'  functions to combine multiple scores and labels.
#'
#' The \code{\link{create_sim_samples}} function creates test datasets with
#'  five different performance levels.
#'
#' @docType package
#' @name precrec
#'
#' @useDynLib precrec
#' @importFrom Rcpp sourceCpp
#' @importFrom ggplot2 autoplot
#' @importFrom ggplot2 fortify
#' @importFrom grDevices col2rgb rainbow rgb
#' @importFrom graphics abline layout legend lines matplot par plot plot.new polygon
#' @importFrom methods is
#' @importFrom stats qnorm rbeta rnorm
#'
NULL

.onUnload <- function (libpath) {
  library.dynam.unload("precrec", libpath)
}

#' Balanced data with 500 positives and 500 negatives.
#'
#' A list contains labels and scores of five different levels.
#' All scores were randomly generated.
#'
#' @format A list with 8 items.
#' \describe{
#'   \item{np}{number of positives: 500}
#'   \item{nn}{number of negatives: 500}
#'   \item{labels}{labels of observed data}
#'   \item{random_scores}{scores of random performance level}
#'   \item{poor_er_scores}{scores of poor early retrieval level}
#'   \item{good_er_scores}{scores of good early retrieval level}
#'   \item{excel_scores}{scores of excellent level}
#'   \item{perf_scores}{scores of perfect level}
#' }
#'
#' @docType data
#' @keywords datasets
#' @name B500
#' @usage data(B500)
NULL

#' Balanced data with 1000 positives and 1000 negatives.
#'
#' A list contains labels and scores of five different levels.
#' All scores were randomly generated.
#'
#' @format A list with 8 items.
#' \describe{
#'   \item{np}{number of positives: 1000}
#'   \item{nn}{number of negatives: 1000}
#'   \item{labels}{labels of observed data}
#'   \item{random_scores}{scores of random performance level}
#'   \item{poor_er_scores}{scores of poor early retrieval level}
#'   \item{good_er_scores}{scores of good early retrieval level}
#'   \item{excel_scores}{scores of excellent level}
#'   \item{perf_scores}{scores of perfect level}
#' }
#'
#' @docType data
#' @keywords datasets
#' @name B1000
#' @usage data(B1000)
NULL

#' Imbalanced data with 500 positives and 5000 negatives.
#'
#' A list contains labels and scores of five different levels.
#' All scores were randomly generated.
#'
#' @format A list with 8 items.
#' \describe{
#'   \item{np}{number of positives: 500}
#'   \item{nn}{number of negatives: 5000}
#'   \item{labels}{labels of observed data}
#'   \item{random_scores}{scores of random performance level}
#'   \item{poor_er_scores}{scores of poor early retrieval level}
#'   \item{good_er_scores}{scores of good early retrieval level}
#'   \item{excel_scores}{scores of excellent level}
#'   \item{perf_scores}{scores of perfect level}
#' }
#'
#' @docType data
#' @keywords datasets
#' @name IB500
#' @usage data(IB500)
NULL

#' Imbalanced data with 1000 positives and 10000 negatives.
#'
#' A list contains labels and scores of five different levels.
#' All scores were randomly generated.
#'
#' @format A list with 8 items.
#' \describe{
#'   \item{np}{number of positives: 1000}
#'   \item{nn}{number of negatives: 10000}
#'   \item{labels}{labels of observed data}
#'   \item{random_scores}{scores of random performance level}
#'   \item{poor_er_scores}{scores of poor early retrieval level}
#'   \item{good_er_scores}{scores of good early retrieval level}
#'   \item{excel_scores}{scores of excellent level}
#'   \item{perf_scores}{scores of perfect level}
#' }
#'
#' @docType data
#' @keywords datasets
#' @name IB1000
#' @usage data(IB1000)
NULL

#' A small example dataset with several tied scores.
#'
#' A list contains labels and scores with tied scores
#'
#' @format A list with 4 items.
#' \describe{
#'   \item{np}{number of positives: 10}
#'   \item{nn}{number of negatives: 10}
#'   \item{labels}{20 labels of observed data}
#'   \item{scores}{20 scores with some ties}
#' }
#'
#' @docType data
#' @keywords datasets
#' @name P10N10
#' @usage data(P10N10)
NULL
