\name{regpop.sar}
\alias{regpop.sar}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Simulation of abundance matrices (non-clustered)}
\description{
  Generates a simulated matrix where the rows are interpreted as regions
  and the columns as species, and the entries are abundances.
  Species are generated i.i.d. in two steps. In the first step, a
  presence-absence matrix is generated as in \code{randpop.nb}. In the
  second step, conditionally on presence in the first step, abundance
  values are generated according to a simultaneous autoregression (SAR)
  model for the log-abundances (see \code{\link[spdep]{errorsarlm}} for
  the model; estimates are provided by the parameter
  \code{sarestimate}). Spatial autocorrelation of a species' presences
  is governed by the parameter \code{p.nb}, \code{sarestimate} and a
  list of neighbors for each region.
}
\usage{
regpop.sar(abmat, prab01=NULL, sarestimate=prab.sarestimate(abmat),
                    p.nb=NULL,
                    vector.species=prab01$regperspec,
                    pdf.regions=prab01$specperreg/(sum(prab01$specperreg)),
                   count=FALSE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{abmat}{object of class \code{prab}, containing the abundance or
    presence/absence data.}
  \item{prab01}{presence-absence matrix of same dimensions than the
  abundance matrix of \code{prabobj}. This specifies the presences and
  absences on which the presence/absence step of abundance-based tests
  is based (see details). If \code{NULL} (which is usually the only
  reasonable choice), \code{prab01} is computed in order to indicate
  the nonzeroes of \code{prabobj$prab}.}
  \item{sarestimate}{Estimator of the parameters of a simultaneous
  autoregression model corresponding to the null model for abundance
  data from Hausdorf and Hennig (2007) as generated by
  \code{prab.sarestimate}. This requires package \code{spdep}. If
  \code{sarestimate$sar=FALSE}, spatial structure is ignored for
  generating the abundance values.}
  \item{p.nb}{numeric between 0 and 1. The probability that a new
    region is drawn from the non-neighborhood of the previous regions
    belonging to a species under generation. If \code{NULL}, the spatial
    structure of the regions is ignored. Note that for a given
    presence-absence matrix, this parameter can be estimated by
    \code{autoconst} (called \code{pd} there).}
  \item{vector.species}{vector of integers. \code{vector.species} gives
    the sizes (i.e., numbers of regions) of
    the species to generate..}
  \item{pdf.regions}{numerical vector of length \code{n.species}. The
    entries must sum up to 1 and give probabilities for the regions to
    be drawn during the generation of a species. These probabilities are
    used conditional on the new region being a neighbor or a
    non-neighbor of the previous regions of the species, see
    \code{p.nb}.}
  \item{count}{logical. If \code{TRUE}, the number of the currently
    generated species is printed.}
}
\value{
  A matrix of abundance values, rows are regions, columns are species.
}
\references{
  Hausdorf, B. and Hennig, C. (2007) Null model tests of clustering of
  species, negative co-occurrence patterns and nestedness in meta-communities.
  \emph{Oikos} 116, 818-828. 
}

\author{Christian Hennig
  \email{chrish@stats.ucl.ac.uk}
  \url{http://www.homepages.ucl.ac.uk/~ucakche}}

\seealso{
  \code{\link{autoconst}} estimates \code{p.nb} from matrices of class
  \code{prab}. These are generated by \code{\link{prabinit}}.
  
  \code{\link{abundtest}} uses \code{regpop.sar} as a null model for
  tests of clustering.

  \code{\link{randpop.nb}} (analogous function for simulating
  presence-absence data)
}

\examples{
data(siskiyou)
set.seed(1234)
x <- prabinit(prabmatrix=siskiyou, neighborhood=siskiyou.nb,
             distance="none")
# Not run; this needs package spdep.
# regpop.sar(x, p.nb=0.046)
regpop.sar(x, p.nb=0.046, sarestimate=prab.sarestimate(x,sar=FALSE))
}
\keyword{spatial}% at least one, from doc/KEYWORDS

