% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ppiIND2016_r59}
\alias{ppiIND2016_r59}
\title{Poverty Probability Index (PPI) lookup table for India using r59 poverty
definitions}
\format{
A data frame with 4 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{saxena}}{National saxena}
\item{\code{ppp108}}{Below $1.08 per day purchasing power parity (1993)}
\item{\code{ppp216}}{Below $2.16 per day purchasing power parity (1993)}
}
}
\source{
\url{https://www.povertyindex.org}
}
\usage{
ppiIND2016_r59
}
\description{
Poverty Probability Index (PPI) lookup table for India using r59 poverty
definitions
}
\examples{
  # Access India PPI table
  ppiIND2016_r59

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiIND2016_r59[ppiIND2016_r59$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiIND2016_r59, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the saxena
  # poverty definition
  ppiScore <- 50
  ppiIND2016_r59[ppiIND2016_r59$score == ppiScore, "saxena"]

}
\keyword{datasets}
