% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/relative_poisson.R
\name{relpois}
\alias{relpois}
\title{Excess hazard Poisson model}
\usage{
relpois(data, formula, fot.breaks = NULL, subset = NULL, check = TRUE,
  ...)
}
\arguments{
\item{data}{a dataset splitted with e.g. \code{\link{lexpand}};
must have expected hazard merged within}

\item{formula}{a formula which is passed on to \code{glm}; see Details}

\item{fot.breaks}{optional; a numeric vector of [a,b) breaks to specify
survival intervals over the follow-up time; if \code{NULL}, the
existing breaks along the mandatory \code{fot} time scale in \code{data}
are used (e.g. the breaks for \code{fot} supplied to \code{lexpand})}

\item{subset}{a logical vector or condition; e.g. \code{subset = sex == 1};
limits the data before estimation}

\item{check}{logical; if \code{TRUE}, tabulates excess cases by all
factor variables in the formula to check for negative / \code{NA}
excess cases before fitting the glm}

\item{...}{any argument passed on to \code{glm}}
}
\value{
A \code{glm} object created using a custom Poisson family construct. Some
\code{glm} methods are applicable.
}
\description{
Estimate a Poisson piecewise constant excess
hazards model
}
\details{
\strong{Basics}

\code{relpois} employs a custom link function of the Poisson variety
to estimate piecewise constant parametric excess hazards. The pieces
are determined by \code{fot.breaks}. A \code{log(person-years)} offset
is passed automatically to the \code{glm} call.

\strong{Formula usage}

The formula can be used like any ordinary \code{glm} formula. The user must
define the outcome in some manner, which is usually \code{lex.Xst} after splitting
with e.g. \code{lexpand}. The exception is the possibility of including
the baseline excess hazard terms by including the
reserved term \code{FOT} in the formula.

For example, \code{lex.Xst != 0 ~ FOT + agegr} estimates a model with constant
excess hazards at the follow-up intervals as specified by
the pertinent breaks used in splitting \code{data},
as well as for the different age groups.
\code{FOT} is created ad hoc if it is used in the formula.
If you leave out \code{FOT}, the hazard is effectively
assumed to be constant across the whole follow-up time.

You can also simply use your own follow-up time interval variable that
you have created before calling \code{relpois}. However, when using
\code{FOT}, \code{relpois} automatically checks for e.g.
negative excess cases in follow-up intervals,
allowing for quickly finding splitting breaks
where model estimation is possible. It also drops any data outside the
follow-up time window.

\strong{Splitting and merging population hazard}

The easiest way to both split and to include population hazard information is
by using \code{\link{lexpand}}. You may also fairly easily do it by hand
by splitting first and then merging in your population hazard information.


\strong{Data requirements}

The population hazard information must be available for each record and named
\code{pop.haz}. The follow-up time variable must be named \code{"fot"} e.g.
as a result of using \code{lexpand}. The \code{lex.dur} variable must also
be present, containing person-year information.
}
\examples{
## use the simulated rectal cancer cohort
sr <- copy(sire)
sr$agegr <- cut(sr$dg_age, c(0,45,60,Inf), right=FALSE)

## usable straight away after splitting
fb <- c(0,3/12,6/12,1,2,3,4,5)
x <- lexpand(sr, breaks = list(fot=fb), pophaz=popmort, status=status)
rpm <- relpois(x, formula = lex.Xst \%in\% 1:2 ~ FOT + agegr)

## some methods for glm work. e.g. test for interaction
# rpm2 <- relpois(x, formula = lex.Xst \%in\% 1:2 ~ FOT*agegr)
# anova(rpm, rpm2, test="LRT")
# AIC(rpm, rpm2)
}
\author{
Joonas Miettinen, Karri Seppa
}
\seealso{
\code{\link{lexpand}}, \code{\link{poisson}}, \code{\link{glm}}
}

