% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{get.yrs}
\alias{get.yrs}
\title{Convert date objects to fractional years}
\usage{
get.yrs(dates, format = "\%Y-\%m-\%d", year.length = "approx")
}
\arguments{
\item{dates}{a vector or column of Date objects or right kind of character strings, see Details}

\item{format}{a character string; if \code{dates} is a character vector,
specifies the format; see \code{\link{as.Date}}}

\item{year.length}{character string, either \code{'actual'} or
\code{'approx'}; can be abbreviated; see Details}
}
\description{
Using Date objects, calculates given
dates as fractional years.
}
\details{
\code{dates} should preferably be a \code{date}, \code{Date} or \code{IDate}
object,
although they can also be character strings in a format
specified by \code{format} (passed to \code{\link{as.Date}}).

When \code{ year.length = 'actual' }, fractional years are calculated as
\code{ year + day_in_year/365 } for non-leap-years
and as \code{ year + day_in_year/366 } for leap years.
If \code{ year.length = 'approx' }, fractional years are always
calculated as in \code{ year + day_in_year/365.242199 }.

There is a slight difference, then, between the two methods
when calculating durations between fractional years. For
meticulous accuracy one might instead want to calculate durations using
dates (days) and convert the results to fractional years.

Note that dates are effectively converted to fractional years at
\code{ 00:00:01 } o'clock:


\code{ get.yrs("2000-01-01") = 2000 }, and
\code{ get.yrs("2000-01-02") = 2000 + 1/365.242199 }.
}
\examples{
test <- copy(sire)
test$dg_yrs <- get.yrs(test$dg_date)
summary(test$dg_yrs)

## Epi's cal.yr versus get.yrs
Epi::cal.yr("2000-01-01") ## 1999.999
get.yrs("2000-01-01") ## 2000
}
\author{
Joonas Miettinen
}
\seealso{
\code{\link[Epi]{cal.yr}}
}

