% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_traj.R
\name{filter_traj}
\alias{filter_traj}
\alias{filter_traj,ANY-method}
\alias{filter_traj,missing-method}
\alias{filter_traj,pfilterd_pomp-method}
\alias{filter_traj,listie-method}
\alias{filter_traj,pmcmcd_pomp-method}
\title{Filtering trajectories}
\usage{
\S4method{filter_traj}{pfilterd_pomp}(object, vars, ..., format = c("array", "data.frame"))

\S4method{filter_traj}{listie}(object, vars, ..., format = c("array", "data.frame"))

\S4method{filter_traj}{pmcmcd_pomp}(object, vars, ...)
}
\arguments{
\item{object}{result of a filtering computation}

\item{vars}{optional character; names of variables}

\item{...}{ignored}

\item{format}{format of the returned object}
}
\description{
Drawing from the smoothing distribution
}
\details{
The smoothing distribution is the distribution of
\deqn{X(t_k) | Y(t_1)=y^*_1, \dots, Y(t_n)=y^*_n,}{Xk | Y1=y1*, \dots, Yn=yn*,}
where \eqn{X(t_k)}{Xk} is the latent state process and \eqn{Y(t_k)}{Yk} is the observable process at time \eqn{t_k}{tk}, and \eqn{n} is the number of observations.

To draw samples from this distribution, one can run a number of independent particle filter (\code{\link{pfilter}}) operations, sampling the full trajectory of \emph{one} randomly-drawn particle from each one.
One should view these as \emph{weighted} samples from the smoothing distribution, where the weights are the \emph{likelihoods} returned by each of the \code{\link{pfilter}} computations.

One accomplishes this by setting \code{filter.traj = TRUE} in each \code{\link{pfilter}} computation and extracting the trajectory using the \code{filter_traj} command.

In particle MCMC (\code{\link{pmcmc}}), the tracking of an individual trajectory is performed automatically.
}
\seealso{
More on sequential Monte Carlo methods: 
\code{\link{bsmc2}()},
\code{\link{cond_logLik}()},
\code{\link{eff_sample_size}()},
\code{\link{filter_mean}()},
\code{\link{kalman}},
\code{\link{mif2}()},
\code{\link{pfilter}()},
\code{\link{pmcmc}()},
\code{\link{pred_mean}()},
\code{\link{pred_var}()},
\code{\link{saved_states}()},
\code{\link{wpfilter}()}

Other extraction methods: 
\code{\link{coef}()},
\code{\link{cond_logLik}()},
\code{\link{covmat}()},
\code{\link{eff_sample_size}()},
\code{\link{filter_mean}()},
\code{\link{forecast}()},
\code{\link{logLik}},
\code{\link{obs}()},
\code{\link{pred_mean}()},
\code{\link{pred_var}()},
\code{\link{saved_states}()},
\code{\link{spy}()},
\code{\link{states}()},
\code{\link{summary}()},
\code{\link{timezero}()},
\code{\link{time}()},
\code{\link{traces}()}
}
\concept{extraction methods}
\concept{particle filter methods}
