% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abc.R
\docType{methods}
\name{abc}
\alias{abc}
\alias{abc,missing-method}
\alias{abc,ANY-method}
\alias{abc,data.frame-method}
\alias{abc,pomp-method}
\alias{abc,probed_pomp-method}
\alias{abc,abcd_pomp-method}
\title{Approximate Bayesian computation}
\usage{
\S4method{abc}{data.frame}(
  data,
  Nabc = 1,
  proposal,
  scale,
  epsilon,
  probes,
  params,
  rinit,
  rprocess,
  rmeasure,
  dprior,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{abc}{pomp}(
  data,
  Nabc = 1,
  proposal,
  scale,
  epsilon,
  probes,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{abc}{probed_pomp}(data, probes, ..., verbose = getOption("verbose", FALSE))

\S4method{abc}{abcd_pomp}(
  data,
  Nabc,
  proposal,
  scale,
  epsilon,
  probes,
  ...,
  verbose = getOption("verbose", FALSE)
)
}
\arguments{
\item{data}{either a data frame holding the time series data,
or an object of class \sQuote{pomp},
i.e., the output of another \pkg{pomp} calculation.
Internally, \code{data} will be coerced to an array with storage-mode \code{double}.}

\item{Nabc}{the number of ABC iterations to perform.}

\item{proposal}{optional function that draws from the proposal
distribution.  Currently, the proposal distribution must be symmetric for
proper inference: it is the user's responsibility to ensure that it is.
Several functions that construct appropriate proposal function are
provided: see \link[=proposals]{MCMC proposals} for more information.}

\item{scale}{named numeric vector of scales.}

\item{epsilon}{ABC tolerance.}

\item{probes}{a single probe or a list of one or more probes.
A probe is simply a scalar- or vector-valued function of one argument that can be applied to the data array of a \sQuote{pomp}.
A vector-valued probe must always return a vector of the same size.
A number of useful probes are provided with the package:
see \link[=basic_probes]{basic probes}.}

\item{params}{optional; named numeric vector of parameters.
This will be coerced internally to storage mode \code{double}.}

\item{rinit}{simulator of the initial-state distribution.
This can be furnished either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rinit=NULL} sets the initial-state simulator to its default.
For more information, see \link[=rinit_spec]{rinit specification}.}

\item{rprocess}{simulator of the latent state process, specified using one of the \link[=rprocess_spec]{rprocess plugins}.
Setting \code{rprocess=NULL} removes the latent-state simulator.
For more information, see \link[=rprocess_spec]{rprocess specification for the documentation on these plugins}.}

\item{rmeasure}{simulator of the measurement model, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rmeasure=NULL} removes the measurement model simulator.
For more information, see \link[=rmeasure_spec]{rmeasure specification}.}

\item{dprior}{optional; prior distribution density evaluator, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
For more information, see \link[=prior_spec]{prior specification}.
Setting \code{dprior=NULL} resets the prior distribution to its default, which is a flat improper prior.}

\item{...}{additional arguments supply new or modify existing model characteristics or components.
See \code{\link{pomp}} for a full list of recognized arguments.

When named arguments not recognized by \code{\link{pomp}} are provided, these are made available to all basic components via the so-called \dfn{userdata} facility.
This allows the user to pass information to the basic components outside of the usual routes of covariates (\code{covar}) and model parameters (\code{params}).
See \link[=userdata]{userdata} for information on how to use this facility.}

\item{verbose}{logical; if \code{TRUE}, diagnostic messages will be printed to the console.}
}
\description{
The approximate Bayesian computation (ABC) algorithm for estimating the parameters of a partially-observed Markov process.
}
\section{Running ABC}{


\code{abc} returns an object of class \sQuote{abcd_pomp}.
One or more \sQuote{abcd_pomp} objects can be joined to form an \sQuote{abcList} object.
}

\section{Re-running ABC iterations}{


To re-run a sequence of ABC iterations, one can use the \code{abc} method on a \sQuote{abcd_pomp} object.
By default, the same parameters used for the original ABC run are re-used (except for \code{verbose}, the default of which is shown above).
If one does specify additional arguments, these will override the defaults.
}

\section{Continuing ABC iterations}{


One can continue a series of ABC iterations from where one left off using the \code{continue} method.
A call to \code{abc} to perform \code{Nabc=m} iterations followed by a call to \code{continue} to perform \code{Nabc=n} iterations will produce precisely the same effect as a single call to \code{abc} to perform \code{Nabc=m+n} iterations.
By default, all the algorithmic parameters are the same as used in the original call to \code{abc}.
Additional arguments will override the defaults.
}

\section{Methods}{

The following can be applied to the output of an \code{abc} operation:
\describe{
\item{\code{abc}}{repeats the calculation, beginning with the last state}
\item{\code{\link{continue}}}{continues the \code{abc} calculation}
\item{\code{plot}}{produces a series of diagnostic plots}
\item{\code{\link{traces}}}{produces an \code{\link[coda]{mcmc}} object, to which the various \pkg{coda} convergence diagnostics can be applied}
}
}

\section{Note for Windows users}{


Some Windows users report problems when using C snippets in parallel computations.
These appear to arise when the temporary files created during the C snippet compilation process are not handled properly by the operating system.
To circumvent this problem, use the \code{\link[=pomp]{cdir}} and \code{\link[=pomp]{cfile}} options to cause the C snippets to be written to a file of your choice, thus avoiding the use of temporary files altogether.
}

\references{
\Marin2012

\Toni2010

\Toni2009
}
\seealso{
More on methods based on summary statistics: 
\code{\link{basic_probes}},
\code{\link{nlf}},
\code{\link{probe_match}},
\code{\link{probe}()},
\code{\link{spect_match}},
\code{\link{spect}()}

More on \pkg{pomp} estimation algorithms:
\code{\link{bsmc2}()},
\code{\link{estimation_algorithms}},
\code{\link{mif2}()},
\code{\link{nlf}},
\code{\link{pmcmc}()},
\code{\link{pomp-package}},
\code{\link{probe_match}},
\code{\link{spect_match}}

More on Markov chain Monte Carlo methods:
\code{\link{pmcmc}()},
\code{\link{proposals}}

More on Bayesian methods:
\code{\link{bsmc2}()},
\code{\link{dprior}()},
\code{\link{pmcmc}()},
\code{\link{prior_spec}},
\code{\link{rprior}()}
}
\author{
Edward L. Ionides, Aaron A. King
}
\concept{Bayesian methods}
\concept{MCMC methods}
\concept{approximate Bayesian computation}
\concept{estimation methods}
\concept{summary statistic-based methods}
