% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIC_psem.R
\name{AIC.psem}
\alias{AIC.psem}
\title{Generic function for SEM AIC(c) score}
\usage{
\method{AIC}{psem}(object, ..., AIC.type = "loglik", aicc = FALSE)
}
\arguments{
\item{object}{a psem object}

\item{...}{additional arguments to AIC}

\item{AIC.type}{whether the log-likelihood \code{"loglik"} or d-sep \code{"dsep"} AIC score 
should be reported. Default is \code{"loglik"}}

\item{aicc}{whether correction for small sample size should be applied. Default is \code{FALSE}}
}
\description{
Generic function for SEM AIC(c) score
}
\examples{

mod <- psem(
lm(rich ~ cover, data = keeley),
lm(cover ~ firesev, data = keeley),
lm(firesev ~ age, data = keeley),
data = keeley
)

# Get log-likelihood based AIC
AIC(mod)

# Get d-sep based AIC
AIC(mod, AIC.type = "dsep")
 
}
