% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ghosal_Hooker_2018.R
\name{GhosalBoostRF}
\alias{GhosalBoostRF}
\title{Implements RF prediction interval method in Ghosal, Hooker 2018. Helper function.}
\usage{
GhosalBoostRF(
  formula = NULL,
  train_data = NULL,
  pred_data = NULL,
  num_trees = NULL,
  min_node_size = NULL,
  m_try = NULL,
  keep_inbag = TRUE,
  intervals = FALSE,
  alpha = NULL,
  prop = NULL,
  variant = 1,
  num_threads = NULL,
  num_stages = NULL,
  interval_type = NULL
)
}
\arguments{
\item{formula}{Object of class formula or character describing the model to fit. Interaction terms supported only for numerical variables.}

\item{train_data}{Training data of class data.frame, matrix, dgCMatrix (Matrix) or gwaa.data (GenABEL). Matches ranger() requirements.}

\item{pred_data}{Test data of class data.frame, matrix, dgCMatrix (Matrix) or gwaa.data (GenABEL). Utilizes ranger::predict() to get prediction intervals for test data.}

\item{num_trees}{Number of trees.}

\item{min_node_size}{Minimum number of observations before split at a node.}

\item{m_try}{Number of variables to randomly select from at each split.}

\item{keep_inbag}{Saves matrix of observations and which tree(s) they occur in. Required to be true to generate variance estimates for Ghosal, Hooker 2018 method.}

\item{intervals}{Generate prediction intervals or not. Defaults to FALSE.}

\item{alpha}{Significance level for prediction intervals.}

\item{prop}{Proportion of training data to sample for each tree. Currently variant 2 not implemented.}

\item{variant}{Choose which variant to use. Currently variant 2 not implemented.}

\item{num_threads}{The number of threads to use in parallel. Default is the current number of cores.}

\item{num_stages}{Number of boosting stages. Functional for >= 2; variance estimates need adjustment for variant 2.}

\item{interval_type}{Type of prediction interval to generate.
Options are \code{method = c("two-sided", "lower", "upper")}. Default is  \code{method = "two-sided"}.}
}
\description{
This function implements variant one and two of the prediction interval methods in Ghosal, Hooker 2018. Used inside rfint().
}
\keyword{internal}
